/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.uicontrols.wizard;

import filenet.vw.base.VWDebug;
import filenet.vw.base.VWString;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.resources.VWResource;
import filenet.vw.toolkit.utils.uicontrols.wizard.IVWWizardListener;
import filenet.vw.toolkit.utils.uicontrols.wizard.IVWWizardPanel;
import filenet.vw.toolkit.utils.uicontrols.wizard.VWWizardEvent;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.event.EventListenerList;

public abstract class VWWizardPane
extends JPanel
implements ActionListener {
    private List m_panelList = null;
    private int m_nPanelIndex = 0;
    private boolean m_bConfirmOnCancel = true;
    private JFrame m_parentFrame = null;
    private EventListenerList m_wizardListenerList = new EventListenerList();
    private JTextArea m_title = null;
    private JTextArea m_subtitle = null;
    private JPanel m_mainPanel = null;
    private CardLayout m_cardLayout = null;
    private JButton m_backButton = null;
    private JButton m_nextButton = null;
    private JButton m_finishButton = null;
    private JButton m_cancelButton = null;
    private JButton m_helpButton = null;
    private JButton m_closeButton = null;
    public static final int BUTTON_BACK = 0;
    public static final int BUTTON_NEXT = 1;
    public static final int BUTTON_FINISH = 2;
    public static final int BUTTON_CANCEL = 3;
    public static final int BUTTON_HELP = 4;

    public VWWizardPane(JFrame parent) {
        this.m_parentFrame = parent;
        this.initLayout();
    }

    public void addWizardPanel(IVWWizardPanel panel) {
        this.m_panelList.add(panel);
        this.m_mainPanel.add((Component)((JPanel)((Object)panel)), "" + this.m_panelList.size());
        if (this.m_panelList.size() == 1) {
            panel.preExecution();
            this.setTitle(panel.getTitle(), panel.getSubTitle());
        }
        this.updateButtonState();
    }

    public void updateButtonState() {
        IVWWizardPanel panel = this.getCurrentPanel();
        this.m_backButton.setEnabled(this.m_nPanelIndex > 0 && panel.canEnableButton(0));
        this.m_nextButton.setEnabled(this.m_nPanelIndex < this.m_panelList.size() - 1 && panel.canEnableButton(1));
        this.m_finishButton.setEnabled(this.m_nPanelIndex == this.m_panelList.size() - 1 && panel.canEnableButton(2));
        this.m_cancelButton.setEnabled(panel.canEnableButton(3));
        this.m_nextButton.setVisible(this.m_nPanelIndex < this.m_panelList.size() - 1);
        this.m_finishButton.setVisible(this.m_nPanelIndex == this.m_panelList.size() - 1);
        if (this.m_parentFrame != null) {
            if (this.m_nextButton.isVisible() && this.m_nextButton.isEnabled()) {
                this.m_parentFrame.getRootPane().setDefaultButton(this.m_nextButton);
            } else if (this.m_finishButton.isVisible() && this.m_finishButton.isEnabled()) {
                this.m_parentFrame.getRootPane().setDefaultButton(this.m_finishButton);
            } else {
                this.m_parentFrame.getRootPane().setDefaultButton(null);
            }
        }
    }

    public void setConfirmOnCancel(boolean confirm) {
        this.m_bConfirmOnCancel = confirm;
    }

    public void setButtonVisible(int button, boolean visible) {
        switch (button) {
            case 0: {
                this.m_backButton.setVisible(visible);
                break;
            }
            case 1: {
                this.m_nextButton.setVisible(visible);
                break;
            }
            case 2: {
                this.m_finishButton.setVisible(visible);
                break;
            }
            case 3: {
                this.m_cancelButton.setVisible(visible);
                break;
            }
            case 4: {
                this.m_helpButton.setVisible(visible);
            }
        }
    }

    public void setButtonText(int button, String text) {
        switch (button) {
            case 0: {
                this.m_backButton.setText(text);
                break;
            }
            case 1: {
                this.m_nextButton.setText(text);
                break;
            }
            case 2: {
                this.m_finishButton.setText(text);
                break;
            }
            case 3: {
                this.m_cancelButton.setText(text);
                break;
            }
            case 4: {
                this.m_helpButton.setText(text);
            }
        }
    }

    public void addWizardListener(IVWWizardListener wl) {
        this.m_wizardListenerList.add(IVWWizardListener.class, wl);
    }

    public void removeWizardListener(IVWWizardListener wl) {
        this.m_wizardListenerList.remove(IVWWizardListener.class, wl);
    }

    public void actionPerformed(ActionEvent event) {
        try {
            Object object = event.getSource();
            if (object.equals(this.m_backButton)) {
                this.moveBack();
            } else if (object.equals(this.m_nextButton)) {
                Runnable action = new Runnable(){

                    public void run() {
                        try {
                            VWWizardPane.this.getCurrentPanel().postExecution();
                            VWWizardPane.this.moveNext();
                        }
                        catch (Exception e) {
                            VWWizardPane.this.displayError(e);
                        }
                    }
                };
                new Thread(action).start();
            } else if (object.equals(this.m_finishButton)) {
                Runnable action = new Runnable(){

                    public void run() {
                        try {
                            VWWizardPane.this.getCurrentPanel().postExecution();
                            VWWizardPane.this.closeWizard(false);
                        }
                        catch (Exception e) {
                            VWWizardPane.this.displayError(e);
                        }
                    }
                };
                new Thread(action).start();
            } else if (object.equals(this.m_closeButton)) {
                this.closeWizard(false);
            } else if (object.equals(this.m_cancelButton)) {
                this.closeWizard(true);
            } else if (object.equals(this.m_helpButton)) {
                this.showHelp();
            }
        }
        catch (Exception e) {
            this.displayError(e);
        }
    }

    private void initLayout() {
        try {
            this.setLayout(new BorderLayout(4, 4));
            this.m_title = new JTextArea(0, 0);
            this.m_title.setEditable(false);
            this.m_title.setLineWrap(true);
            this.m_title.setWrapStyleWord(true);
            this.m_title.setMargin(new Insets(5, 15, 1, 1));
            this.m_title.setFont(new JLabel().getFont());
            this.m_subtitle = new JTextArea(0, 0);
            this.m_subtitle.setEditable(false);
            this.m_subtitle.setLineWrap(true);
            this.m_subtitle.setWrapStyleWord(true);
            this.m_subtitle.setMargin(new Insets(0, 30, 10, 1));
            JPanel panel = new JPanel(new BorderLayout());
            panel.setBorder(BorderFactory.createEtchedBorder());
            panel.add((Component)this.m_title, "Center");
            panel.add((Component)this.m_subtitle, "Last");
            this.add((Component)panel, "First");
            this.add((Component)this.getMainPanel(), "Center");
            this.add((Component)this.getButtonPanel(), "Last");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private JPanel getMainPanel() {
        if (this.m_mainPanel == null) {
            this.m_cardLayout = new CardLayout();
            this.m_mainPanel = new JPanel(this.m_cardLayout);
            this.m_panelList = new ArrayList();
            this.m_nPanelIndex = 0;
        }
        return this.m_mainPanel;
    }

    private JPanel getButtonPanel() {
        JPanel panel = null;
        panel = new JPanel(new FlowLayout());
        this.m_backButton = new JButton(VWResource.s_backArrow);
        panel.add(this.m_backButton);
        this.m_backButton.setEnabled(false);
        this.m_backButton.addActionListener(this);
        this.m_nextButton = new JButton(VWResource.s_nextArrow);
        panel.add(this.m_nextButton);
        this.m_nextButton.addActionListener(this);
        this.m_finishButton = new JButton(VWResource.s_finish);
        panel.add(this.m_finishButton);
        this.m_finishButton.setEnabled(false);
        this.m_finishButton.addActionListener(this);
        this.m_cancelButton = new JButton(VWResource.s_cancel);
        panel.add(this.m_cancelButton);
        this.m_cancelButton.addActionListener(this);
        this.m_closeButton = new JButton(VWResource.s_close);
        this.m_closeButton.setVisible(false);
        panel.add(this.m_closeButton);
        this.m_closeButton.addActionListener(this);
        this.m_helpButton = new JButton(VWResource.s_help + "...");
        panel.add(this.m_helpButton);
        this.m_helpButton.addActionListener(this);
        return panel;
    }

    protected IVWWizardPanel getCurrentPanel() {
        return (IVWWizardPanel)this.m_panelList.get(this.m_nPanelIndex);
    }

    private void moveBack() {
        if (this.m_panelList != null && this.m_nPanelIndex > 0) {
            this.m_cardLayout.previous(this.m_mainPanel);
            --this.m_nPanelIndex;
            IVWWizardPanel panel = this.getCurrentPanel();
            panel.preExecution();
            this.setTitle(panel.getTitle(), panel.getSubTitle());
            this.updateButtonState();
            this.updateButtonFocus();
        }
    }

    private void moveNext() {
        if (this.m_panelList != null && this.m_nPanelIndex < this.m_panelList.size() - 1) {
            this.m_cardLayout.next(this.m_mainPanel);
            ++this.m_nPanelIndex;
            final IVWWizardPanel panel = this.getCurrentPanel();
            this.setTitle(panel.getTitle(), panel.getSubTitle());
            this.updateButtonState();
            this.updateButtonFocus();
            Runnable action = new Runnable(){

                public void run() {
                    panel.preExecution();
                }
            };
            new Thread(action).start();
        }
    }

    private void updateButtonFocus() {
        if (this.m_nextButton.isEnabled()) {
            this.m_nextButton.requestFocus();
        } else if (this.m_finishButton.isEnabled()) {
            this.m_finishButton.requestFocus();
        } else if (this.m_backButton.isEnabled()) {
            this.m_backButton.requestFocus();
        }
    }

    private void setTitle(String title, String subtitle) {
        if (title != null) {
            this.m_title.setText(title);
        }
        if (subtitle != null) {
            this.m_subtitle.setText(subtitle);
        }
        this.m_title.setVisible(title != null);
        this.m_subtitle.setVisible(subtitle != null);
    }

    protected void showHelp() {
        VWHelp.displayPage(this.getCurrentPanel().getHelpPath());
    }

    private void closeWizard(boolean wizardCanceled) {
        if (wizardCanceled) {
            String msg;
            if (this.m_bConfirmOnCancel && !this.displayConfirmation(msg = new VWString("filenet.vw.toolkit.utils.uicontrols.wizard.VWWizardPane.CancelMessage", "Do you really want to cancel?").toString())) {
                return;
            }
            Runnable action = new Runnable(){

                public void run() {
                    VWWizardPane.this.m_cancelButton.setEnabled(false);
                    if (VWWizardPane.this.getCurrentPanel().cancel()) {
                        VWWizardPane.this.fireWizardClosedEvent(new VWWizardEvent(this, true));
                    } else {
                        VWWizardPane.this.m_cancelButton.setEnabled(true);
                    }
                }
            };
            new Thread(action).start();
        } else {
            this.fireWizardClosedEvent(new VWWizardEvent(this, false));
        }
    }

    public void displayInformation(String msg) {
        VWMessageDialog.showOptionDialog((Frame)this.m_parentFrame, msg, 2);
    }

    public boolean displayConfirmation(String msg) {
        int dlgResult = VWMessageDialog.showOptionDialog((Frame)this.m_parentFrame, msg, VWResource.s_confirmation, 4, 3, null, null, 0, 0);
        return dlgResult == 1;
    }

    public void displayError(Throwable ex) {
        this.displayError(ex, false);
    }

    public void displayError(Throwable ex, boolean displayStackTrace) {
        String msg = ex.getLocalizedMessage();
        StringWriter stackTrace = new StringWriter();
        ex.printStackTrace(new PrintWriter(stackTrace));
        if (msg == null || displayStackTrace) {
            msg = stackTrace.toString();
        }
        VWMessageDialog.showOptionDialog((Frame)this.m_parentFrame, msg, 1);
    }

    private void fireWizardClosedEvent(VWWizardEvent event) {
        Object[] listeners = this.m_wizardListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != IVWWizardListener.class) continue;
            ((IVWWizardListener)listeners[i + 1]).wizardClosed(event);
        }
    }
}

